USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetVisnsByRegions1]    Script Date: 6/14/2016 9:20:53 AM ******/
DROP PROCEDURE [dbo].[usp_GetVisnsByRegions1]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetVisnsByRegions1]    Script Date: 6/14/2016 9:20:53 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


--exec usp_GetVisnsByRegions @USER_NAME=N'DNS',@REGION_EXTENSIONS=N'37483721-6A2E-410D-9182-2ADAEF79141D,3F5AEAE3-46E6-4BB7-88F8-CF40F75D3C95,9AD81810-79F1-4741-9BD8-4DF3A882116C,51637814-570E-4818-893F-104EA1179A2C',@VISN_EXTENSION=NULL
CREATE PROCEDURE [dbo].[usp_GetVisnsByRegions1]
	@USER_NAME NVARCHAR(100),
	@REGION_EXTENSIONS NVARCHAR(MAX),
	@VISN_EXTENSION nvarchar(250) = NULL
AS
BEGIN

	DECLARE @SQL_SELECT NVARCHAR(4000), @SQL_WHERE NVARCHAR(4000), @SQL_ORDER_BY NVARCHAR(4000), @SQL NVARCHAR(4000)
		
	--create temporary REGION table
	CREATE TABLE #TBL_REGION
	(
	  EXT uniqueidentifier PRIMARY KEY
	)
	
	-- create permission table
	CREATE TABLE #PERMISSION
        (
         DIM_ORGANIZATION_ID INT,
         DIM_WARD_ID INT
        )
    
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
		
	INSERT INTO #TBL_REGION(EXT) 
	SELECT CONVERT(uniqueidentifier, VALUE) FROM dbo.ufn_Split(@REGION_EXTENSIONS, ',')
	
	DECLARE @DIM_ORGANIZATION_TYPE_ID int
	SET @DIM_ORGANIZATION_TYPE_ID = (SELECT ID
	FROM DIM_ORGANIZATION_TYPE
	WHERE CODE='VISN')
	
	SET @SQL_SELECT = 'SELECT DISTINCT VISN.SOURCE_ID AS SOURCE_ID, VISN.ID, VISN.NAME AS NAME, cast(VISN.CODE as int) as CODE
						FROM DIM_ORGANIZATION AS VISN 
							INNER JOIN 
							(
								#PERMISSION P INNER JOIN DIM_ORGANIZATION AS FACILITY ON FACILITY.ID = P.DIM_ORGANIZATION_ID
								INNER JOIN DIM_ORGANIZATION AS VISTA_SITE ON FACILITY.DIM_ORGANIZATION_ID = VISTA_SITE.ID
							) ON VISN.ID = VISTA_SITE.DIM_ORGANIZATION_ID'
					
    SET @SQL_WHERE = ' WHERE VISN.DIM_ORGANIZATION_TYPE_ID = ' + CAST(@DIM_ORGANIZATION_TYPE_ID AS varchar) + '
					   AND VISN.DIM_ORGANIZATION_ID in (SELECT ID FROM DIM_ORGANIZATION WHERE SOURCE_ID IN (SELECT EXT FROM #TBL_REGION))'	
					   
	IF @VISN_EXTENSION IS NOT NULL
     SET @SQL_WHERE = @SQL_WHERE + ' AND VISN.SOURCE_ID = ''' + @VISN_EXTENSION + ''''
     
    SET @SQL_ORDER_BY = ' ORDER BY cast(VISN.CODE as int)'
    
    SET @SQL = @SQL_SELECT + @SQL_WHERE + @SQL_ORDER_BY
	
	EXECUTE sp_executesql @SQL
	
	DROP TABLE #PERMISSION
	DROP TABLE #TBL_REGION   					   				

END


GO


